/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipObject_Identity.h 69825 2017-06-29 09:29:26Z kai $:

Description:
  Identity Object Definitions

**************************************************************************************/

#ifndef __EIP_OBJECT_IDENTITIY_H
  #define __EIP_OBJECT_IDENTITIY_H

#include "rX_Types.h"

  /*
  ************************************************************
  *  Object specific defines
  ************************************************************
  */

  #define EIP_ID_SERIAL_NUMBER      0x12345678L
  #define EIP_ID_CLASS_NUMBER       0x01
  #define EIP_ID_REVISION           0x01
  #define EIP_ID_MAX_INSTANCE       0x01
  #define EIP_ID_MAX_CLASS_ATTR     7
  #define EIP_ID_MAX_INSTANCE_ATTR  9

  /*
  ** State defines
  */

  #define EIP_ID_STATE_NONEXISTENT                  0
  #define EIP_ID_STATE_DEVICESELFTEST               1
  #define EIP_ID_STATE_STANDBY                      2
  #define EIP_ID_STATE_OPERATIONAL                  3
  #define EIP_ID_STATE_MAJOR_RECOVERABLE_FAULT      4
  #define EIP_ID_STATE_MAJOR_UNRECOVERABLE_FAULT    5
  #define EIP_ID_STATE_DEFAULT                    255

  /*
  ** Defines of the status bits
  */

  #define EIP_ID_STATUS_OWNED_MASK                 0x0001
  #define EIP_ID_STATUS_OWNED                      0x0001
  #define EIP_ID_STATUS_UNOWNED                    0x0000

  #define EIP_ID_STATUS_CONFIGURED_MASK            0x0004
  #define EIP_ID_STATUS_UNCONFIGURED               0x0000
  #define EIP_ID_STATUS_CONFIGURED                 0x0004

  /* Extended device status field values. */
  #define EIP_ID_STATUS_EXTENDED_STATUS_MASK                                                     0x00F0
  #define EIP_ID_STATUS_EXTENDED_STATUS_SELF_TESTING                                             0x0000
  #define EIP_ID_STATUS_EXTENDED_STATUS_FIRMWARE_UPDATE_IN_PROGRESS                              0x0010
  #define EIP_ID_STATUS_EXTENDED_STATUS_AT_LEAST_ONE_FAULTED_IO_CONNECTION                       0x0020
  #define EIP_ID_STATUS_EXTENDED_STATUS_NO_IO_CONNECTION_ESTABLISHED                             0x0030
  #define EIP_ID_STATUS_EXTENDED_STATUS_NON_VOLATILE_CONFIGURATION_BAD                           0x0040
  #define EIP_ID_STATUS_EXTENDED_STATUS_MAJOR_FAULT                                              0x0050
  #define EIP_ID_STATUS_EXTENDED_STATUS_AT_LEAST_ONE_IO_CONNECTION_IN_RUN_MODE                   0x0060
  #define EIP_ID_STATUS_EXTENDED_STATUS_AT_LEAST_ONE_IO_CONNECTION_ESTABLISHED_ALL_IN_IDLE_MODE  0x0070

  /* Fault bits.*/
  #define EIP_ID_STATUS_FAULT_MASK                 0x0F00
  #define EIP_ID_STATUS_MINOR_RECOVERABLE_FAULT    0x0100
  #define EIP_ID_STATUS_MINOR_UNRECOVERABLE_FAULT  0x0200
  #define EIP_ID_STATUS_MAJOR_RECOVERABLE_FAULT    0x0400
  #define EIP_ID_STATUS_MAJOR_UNRECOVERABLE_FAULT  0x0800

  /* Extended Device Status 2*/
  #define EIP_ID_STATUS_EXTENDED_STATUS_2_MASK                                                   0xF000


  /*
  ************************************************************
  *  Object specific types
  ************************************************************
  */

  typedef struct EIP_ID_CLASS_ATTR_Ttag
  {
    UINT16  usRevision;
    UINT16  usMaxInstance;
    UINT16  usMaxClassAttr;
    UINT16  usMaxInstanceAttr;
  } EIP_ID_CLASS_ATTR_T;

#pragma pack(1)
  typedef __PACKED_PRE struct EIP_ID_INST_ATTR_Ttag
  {
    UINT16  usVendor;
    UINT16  usProductType;
    UINT16  usProductCode;
    UINT8   bMajorRevision;
    UINT8   bMinorRevision;
    UINT16  usStatus;
    UINT32  ulSerialNumber;
    UINT8   abProductName[EIP_ID_MAX_PRODUKTNAME_LEN];
    UINT8   bState;
    UINT16  usConfigConsistent;
    UINT8   bHeartBeatInterval;
  }__PACKED_POST  EIP_ID_INST_ATTR_T;
#pragma pack()
  /*
  ****************************************************************************
  *  Object specific macros
  ****************************************************************************
  */


  /*
  ************************************************************
  *  Task Function Prototypes
  ************************************************************
  */


#endif

